#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

const int N = (1 << 20) + 5;
const int inf = 1e9;
int p[N];
int n, logn;

vector<pair<int, int>> nivo[20];
pair<int, int> segments[20];

void stepen() {
    for (int i = 2; i <= 20; i++)
        if ((1 << i) == n)
            logn = i;
}

void napravi_nivoe() {
    for (int i = 1; i < logn; i++) {
        for (int j = 1; j <= n; j += (1 << i))
            nivo[i].push_back({j, j + (1 << i) - 1});
    }
}

struct segtree {
    vector<vector<int>> tree;
    void init() {
        tree.resize(4 * n * logn);
    }

    void build(int x, int lx, int rx){
        if (rx - lx == 1) {
            tree[x] = {p[lx]};
            return;
        }
        int m = (lx + rx) / 2;
        build(x * 2 + 1, lx, m);
        build(x * 2 + 2, m, rx);
        merge(tree[x * 2 + 1].begin(), tree[x * 2 + 1].end(), tree[x * 2 + 2].begin(), tree[x * 2 + 2].end(), back_inserter(tree[x]));
    }

    int get(int x, int lx, int rx, int l, int r, int s) {
        if (lx >= r || rx <= l) return 0;
        if (lx >= l && rx <= r) {
            int sz = (int)tree[x].size();
            int r = upper_bound(tree[x].begin(), tree[x].end(), s) - tree[x].begin();
            return (sz - r);
        }
        int m = (lx + rx) / 2;
        int s1 = get(x * 2 + 1, lx, m, l, r, s);
        int s2 = get(x * 2 + 2, m, rx, l, r, s);
        return s1 + s2;
    }

    int get(int lx, int rx, int s) {
        return get(0, 1, n+1, lx, rx+1, s);
    }

}; segtree st;

void solve() {
    cin >> n;
    stepen(); st.init();
    for (int i = 1; i <= n; i++) cin >> p[i];
    st.build(0, 1, n+1);
    napravi_nivoe();

    int q; cin >> q;
    while (q--) {
        int m, j; cin >> m >> j;
        if (p[m] == n) {
            cout << logn + 1 << "\n"; continue;
        }
        for (int i = 1; i < logn; i++) {
            auto it = upper_bound(nivo[i].begin(), nivo[i].end(), make_pair(m, inf));
            pair<int, int> t = *prev(it);
            segments[i] = t;
        }

        int low = 0, high = logn;
        while (low + 1 < high) {
            int mid = (low + high) / 2;
            int l, r;
            tie(l, r) = segments[mid];
            int veci = st.get(l, r, p[m]);
            int manji = (r - l + 1) - veci - 1;
            int sporednji_manji = p[m] - 1 - manji;
            //dbg(veci, manji, sporednji_manji, mid, l, r);
            if (sporednji_manji >= veci && j >= veci)
                low = mid;
            else
                high = mid;
        }

        cout << low + 1 << "\n";
    }
}
int main() {
    ios::sync_with_stdio(false); cin.tie(0);
    solve();
}

/*
8
1 8 2 7 4 6 3 5
1
1 8
*/